/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.IRowItem;

final class ComponentHelper {
    private ComponentHelper() {
    }

    static int maxValues(Iterable<? extends IRowItem> items, IExtractor extractor) {
        int max2 = 0;
        for (IRowItem iRowItem : items) {
            max2 = Math.max(max2, extractor.value(iRowItem));
        }
        return max2;
    }

    static int sumValues(Iterable<? extends IRowItem> items, IExtractor extractor) {
        int sum2 = 0;
        for (IRowItem iRowItem : items) {
            sum2 += extractor.value(iRowItem);
        }
        return sum2;
    }

    static int unrelhgap(List<? extends IRowItem> items, Container parent) {
        return ComponentHelper.hgap(ComponentGapsHelper.instance(), items, parent, LayoutStyle.ComponentPlacement.UNRELATED);
    }

    static int hgap(List<? extends IRowItem> items, Container parent) {
        return ComponentHelper.hgap(ComponentGapsHelper.instance(), items, parent, LayoutStyle.ComponentPlacement.RELATED);
    }

    static int hgap(JComponent first, List<? extends IRowItem> items, Container parent) {
        ComponentGapsHelper helper = ComponentGapsHelper.instance();
        int hgap = 0;
        if (first != null && !items.isEmpty()) {
            hgap = ComponentHelper.hgap(helper, first, items.get(0).component(), parent, LayoutStyle.ComponentPlacement.RELATED);
        }
        return Math.max(hgap, ComponentHelper.hgap(helper, items, parent, LayoutStyle.ComponentPlacement.RELATED));
    }

    static boolean isFixedHeight(HeightGrowPolicy policy, Iterable<? extends IRowItem> items) {
        for (IRowItem iRowItem : items) {
            if (!policy.canGrowHeight(iRowItem.component()) || !iRowItem.isLastSpanRow()) continue;
            return false;
        }
        return true;
    }

    private static int hgap(ComponentGapsHelper helper, List<? extends IRowItem> items, Container parent, LayoutStyle.ComponentPlacement placement) {
        int hgap = 0;
        int size2 = items.size() - 1;
        for (int nth = 0; nth < size2; ++nth) {
            JComponent left = items.get(nth).component();
            JComponent right = items.get(nth + 1).component();
            int gap = ComponentHelper.hgap(helper, left, right, parent, placement);
            hgap = Math.max(hgap, gap);
        }
        return hgap;
    }

    private static int hgap(ComponentGapsHelper helper, JComponent left, JComponent right, Container parent, LayoutStyle.ComponentPlacement placement) {
        return helper.getHorizontalGap(left, right, placement, parent);
    }
}

